class PrivimetricsPlugin {
    constructor(API, name, config) {
        this.API = API;
        this.name = name;
        this.config = config;
    }

    addInsertions() {
        this.API.addInsertion('publiiHead', this.injectAnalytics, 1, this);
    }

    injectAnalytics(rendererInstance) {
        if (!this.config.trackingCode || !this.config.endpoint) {
            return '';
        }

        let scriptType = 'text/javascript';
        if (this.config.cookieBannerIntegration) {
            const groupId = this.config.cookieBannerGroup ? this.config.cookieBannerGroup.trim() : 'analytics';
            scriptType = 'gdpr-blocker/' + groupId;
        }

        if (rendererInstance.previewMode && !this.config.previewMode) {
            return '';
        }

        const pluginFolder = 'privimetricsAnalyticsIntegration';
        const siteUrl = rendererInstance.siteConfig.domain || '';
        const scriptSrc = siteUrl + '/media/plugins/' + pluginFolder + '/privimetrics.js';
        
        const noTrackIp = this.config.noTrackIp ? 'true' : 'false';

        return `
<script 
    async
    type="${scriptType}"
    src="${scriptSrc}"
    data-privimetrics-code="${this.config.trackingCode}"
    data-endpoint="${this.config.endpoint}"
    data-not-track-ip="${noTrackIp}">
</script>
`;
    }
}

module.exports = PrivimetricsPlugin;
