;(() => {
  var s = document.currentScript;
  if (!s) return;

  var code = s.getAttribute("data-privimetrics-code");
  if (!code) return;

  var noTrackIp = s.getAttribute("data-not-track-ip") === "true";
  var endpoint = s.getAttribute("data-endpoint");
  if (!endpoint) return;

  var divId = "privimetrics-analytics-system-data";
  var d = document.getElementById(divId);

  if (!d) {
    d = document.createElement("div");
    d.id = divId;
    d.style.display = "none";
    d.setAttribute("data-k", code);
    d.setAttribute("data-e", endpoint);
    document.documentElement.appendChild(d);
  }

  function sendTracking() {
    try {
      var k = d.getAttribute("data-k");
      var e = d.getAttribute("data-e");
      if (!k || !e) return;

      var img = document.createElement("img");
      img.width = 1;
      img.height = 1;
      img.style.display = "none";

      img.src =
        e +
        "?t=" + encodeURIComponent(k) +
        "&p=" + encodeURIComponent(location.href) +
        "&title=" + encodeURIComponent(document.title || "") +
        "&r=" + encodeURIComponent(document.referrer || "d") +
        "&js=1" +
        "&track-ip=" + encodeURIComponent(noTrackIp ? "false" : "true") +
        "&z=" + Math.random();

      document.documentElement.appendChild(img);
    } catch (_) {}
  }

  if (document.readyState === "complete" || document.readyState === "interactive") {
    sendTracking();
  } else {
    document.addEventListener("DOMContentLoaded", sendTracking);
  }
})();